/*********************************************************
 * Copyright (C) 2009 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *********************************************************/

#ifndef _NPA_DEFS_H
#define _NPA_DEFS_H

#define NPA_PLUGIN_NUMPAGES      64
#define NPA_MEMIO_NUMPAGES       32
#define NPA_SHARED_NUMPAGES      6
#define VMXNET3_NPA_CMD_SUCCESS   1
#define VMXNET3_NPA_CMD_FAILURE   0
#define NPA_MAX_PLUGINS_PER_VM   4
#define VMXNET3_PLUGIN_INFO_LEN  32

/* these structure are versioned using the vmxnet3 version */

typedef 
#include "vmware_pack_begin.h"
struct NPA_PluginPages {
   uint64 vaddr;
   uint32 numPages;
   uint32 _pad;
   PPN64  pages[NPA_PLUGIN_NUMPAGES];
}
#include "vmware_pack_end.h"
NPA_PluginPages;

typedef
#include "vmware_pack_begin.h"
struct NPA_MemioPages {
   PPN64  startPPN;
   uint32 numPages;
   uint32 _pad;
}
#include "vmware_pack_end.h"
NPA_MemioPages;

typedef
#include "vmware_pack_begin.h"
struct NPA_SharedPages {
   PPN64  startPPN;
   uint32 numPages;
   uint32 _pad;
}
#include "vmware_pack_end.h"
NPA_SharedPages;

typedef
#include "vmware_pack_begin.h"
struct NPA_PluginConf {
   NPA_PluginPages   pluginPages;
   NPA_MemioPages    memioPages;
   NPA_SharedPages   sharedPages;
   uint64            entryVA;    // address of entry function in the plugin 
   uint32            deviceInfo[VMXNET3_PLUGIN_INFO_LEN]; // opaque data returned by PF driver
   uint64            _reserved;  // give room for an extra pointer
}
#include "vmware_pack_end.h"
NPA_PluginConf;


/* vmkernel and device backend shared definitions */

#define VMXNET3_PLUGIN_NAME_LEN  256
#define VMXNET3_PLUGIN_REPOSITORY "/usr/lib/vmware/npa_plugins"
#define NPA_MEMIO_REGIONS_MAX    6

#endif // _NPA_DEFS_H
