/*********************************************************
 * Copyright (C) 2000 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *********************************************************/

/*
 * balloon_def.h -- 
 *
 *      Definitions for server "balloon" mechanism for reclaiming
 *      physical memory from a VM.
 */

#ifndef _BALLOON_DEF_H
#define _BALLOON_DEF_H

#define INCLUDE_ALLOW_VMX
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

#include "vm_basic_types.h"

/*
 * constants
 */

/* backdoor port */
#define BALLOON_BDOOR_PORT              (0x5670)
#define BALLOON_BDOOR_MAGIC             (0x456c6d6f)

/* backdoor command numbers */
#define BALLOON_BDOOR_CMD_START         (0)
#define BALLOON_BDOOR_CMD_TARGET        (1)
#define BALLOON_BDOOR_CMD_LOCK          (2)
#define BALLOON_BDOOR_CMD_UNLOCK        (3)
#define BALLOON_BDOOR_CMD_GUEST_ID      (4)

/* use config value for max balloon size */
#define BALLOON_MAX_SIZE_USE_CONFIG     (0)

/*
 * Guest identities
 *
 *      Note : all values should fit in 32 bits
 */
typedef enum {
   BALLOON_GUEST_UNKNOWN     = 0,
   BALLOON_GUEST_LINUX       = 1,
   BALLOON_GUEST_BSD         = 2,
   BALLOON_GUEST_WINDOWS_NT4 = 3,
   BALLOON_GUEST_WINDOWS_NT5 = 4,
   BALLOON_GUEST_SOLARIS     = 5,
   BALLOON_GUEST_MACOS       = 6,
   BALLOON_GUEST_FROBOS      = 7,
} BalloonGuest;

/* error codes */
#define BALLOON_SUCCESS                 (0)
#define BALLOON_FAILURE                (-1)
#define BALLOON_ERROR_CMD_INVALID       (1)
#define BALLOON_ERROR_PPN_INVALID       (2)
#define BALLOON_ERROR_PPN_LOCKED        (3)
#define BALLOON_ERROR_PPN_UNLOCKED      (4)
#define BALLOON_ERROR_PPN_PINNED        (5)
#define BALLOON_ERROR_PPN_NOTNEEDED     (6)
#define BALLOON_ERROR_RESET             (7)
#define BALLOON_ERROR_BUSY              (8)

#endif  /* _BALLOON_DEF_H */
